/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.CmUnitAmountDto;

public class CmUnitAmountDao extends PayrollDao {
	
	// e[uyуL[
	public static final String TABLE = "CM_UNIT_AMOUNT";
	public static final String KEY_1 = "K_CODE"   ;	// ЈR[h
	public static final String KEY_2 = "UNIT_TYPE";	// vZP敪
	
	// 
	public static final String COL_K_CODE      = "K_CODE"     ;	// ЈR[h
	public static final String COL_UNIT_TYPE   = "UNIT_TYPE"  ;	// vZP敪
	public static final String COL_UNIT_AMOUNT = "UNIT_AMOUNT";	// vZP
	
	/**
	 * RXgN^
	 */
	public CmUnitAmountDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<CmUnitAmountDto> mappingAll() throws SQLException {
		List<CmUnitAmountDto> all = new ArrayList<CmUnitAmountDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return CmUnitAmountDto R[h
	 * @throws SQLException
	 */
	private CmUnitAmountDto mapping() throws SQLException {
		CmUnitAmountDto dto = new CmUnitAmountDto();
		dto.setKCode     (rs.getString(COL_K_CODE     ));	// ЈR[h
		dto.setUnitType  (rs.getString(COL_UNIT_TYPE  ));	// vZP敪
		dto.setUnitAmount(rs.getDouble(COL_UNIT_AMOUNT));	// vZP
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * ʎ擾(DTOMap)
	 * @return Map }bv
	 * @throws SQLException
	 */
	private Map<String,  List<CmUnitAmountDto>> mappingAllMap() throws SQLException {
		Map<String, List<CmUnitAmountDto>> map = new HashMap<String, List<CmUnitAmountDto>>();
		List<CmUnitAmountDto> list = mappingAll();
		if (list.size() == 0) {
			return map;
		}
		String currentKCode = list.get(0).getKCode();
		int startIndex = 0;
		for (int i = 1; i < list.size(); i++) {
			if (list.get(i).getKCode().equals(currentKCode)) {
				continue;
			}
			map.put(currentKCode, getSubList(list, startIndex, i - 1));
			startIndex = i;
			currentKCode = list.get(i).getKCode();
		}
		map.put(currentKCode, getSubList(list, startIndex, list.size() - 1));
		return map;
	}
	
	/**
	 * TuXg擾
	 * @param list      Xg
	 * @param fromIndex JnCfbNX
	 * @param toIndex   ICfbNX
	 * @return Xg
	 * @throws SQLException
	 */
	private List<CmUnitAmountDto> getSubList(List<CmUnitAmountDto> list, int fromIndex, int toIndex) {
		List<CmUnitAmountDto> subList = new ArrayList<CmUnitAmountDto>();
		for (int i = fromIndex; i <= toIndex; i++) {
			if (i >= list.size()) {
				break;
			}
			subList.add(list.get(i));
		}
		return subList;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmUnitAmountDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<CmUnitAmountDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode    ЈR[h(L[)
	 * @param unitType vZP敪(L[)
	 * @return CmUnitAmountDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmUnitAmountDto findForKey(
			String kCode,
			String unitType
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kCode   );
			setParam(index++, unitType);
			executeQuery();
			CmUnitAmountDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmUnitAmountDto> findForEmployee(
			String kCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ЈɂsbN擾
	 * @param kCode ЈR[h(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmUnitAmountDto> findForUpdate(
			String kCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()) + getForUpdate());
			setParam(index++, kCode);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CmUnitAmountDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(CmUnitAmountDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode   ());
			setParam(index++, dto.getUnitType());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^폜
	 * @param kCode 폜ΏێЈR[h
	 * @return int 폜()
	 * @throws SQLException
	 */
	public int deleteForEmployee(String kCode) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(CmUnitAmountDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode   ());
			setParam(index++, dto.getUnitType());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(lo͗p)
	 * @return Map (DTOListMap)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 */
	public Map<String, List<CmUnitAmountDto>> findForHumanData(
			) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAllMap();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(CmUnitAmountDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode     ());	// ЈR[h
		setParam(index++, dto.getUnitType  ());	// vZP敪
		setParam(index++, dto.getUnitAmount());	// vZP
		setCommonParams(isInsert);
	}
}
